ORCA/M Asm65816 2.1.0

0001 B916                       TITLE 'BATTERYRAM/Clock Chip Rtnes'
0002 B916
0003 B916              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 B916              ;	by EdAsmCvtIIGS version 1.2d5 on 5/9/91 at 7:18:34 PM
0005 B916
0006 B916              ******************************************************
0007 B916              *                                                    *
0008 B916              *              BATTERYRAM/Clock Routines             *
0009 B916              *                                                    *
0010 B916              *                    by                              *
0011 B916              *               Fern Bachman     1985-1987           *
0012 B916              *               Joe Bo           1987-1989           *
0013 B916              *                                                    *
0014 B916              *       Copyright Apple Computer, Inc. 1985-1989     *
0015 B916              *                All Rights Reserved.                *
0016 B916              *                                                    *
0017 B916              ******************************************************
0018 B916
0019 B916
0020 B916              * The INITCLOCK code guarantees that the clock
0021 B916              * chip is not in test mode and that it is write
0022 B916              * enabled.  Doing this does not alter the data
0023 B916              * in the clock chip and therefore it is performed
0024 B916              * on every coldstart of the system.
0025 B916
0026 B916                                                      ; SEG $FF
0027 B916              INITCLOCK EQU   *
0028 B916                                                      ; SEG $00
0029 B916 A9 37                 LDA   #$37                     ;Write protect address
0030 B918 A0 55                 LDY   #$55                     ;Reset write protect register
0031 B91A 20 9E BA              JSR   WRITE1BYTE               ;Send byte to clock chip
0032 B91D A9 31                 LDA   #$31                     ;Test mode address
0033 B91F A0 00                 LDY   #$00                     ;Disable test mode
0034 B921 20 9E BA              JSR   WRITE1BYTE               ;Send byte to clock chip
0035 B924 6B                    RTL                            ;Make callable from anywhere with JSL
0036 B925
0037 B925              * WRITESTD puts Apple standard parameters into
0038 B925              * the buffer BRAMBUFFER and then writes this data
0039 B925              * to the clock chips memory BATTERYRAM.
0040 B925
0041 B925                                                      ; SEG $FF
0042 B925              WRITESTD EQU   *
0043 B925                                                      ; SEG $00
0044 B925 08                    PHP                            ;Preserve interrupt status
0045 B926 78                    SEI                            ;
0046 B927 8B                    PHB                            ;Save current data bank
0047 B928 20 82 F8              JSR   DBTOE1                   ;Switch to bank $e1
0048 B92B A2 00                 LDX   #$00                     ;Start with 1st byte to move to buffer
0049 B92D              @1       EQU   *
0050 B92D BF C5 83 FF           LDA   >CPDEFTBL,X              ;Default parameter
0051 B931 9D C0 02              STA   |BRAMBUFFER,X            ;Put in buffer
0052 B934 E8                    INX                            ;Next please
0053 B935 E0 5A                 CPX   #CPDTBLLN                ;Test against max
0054 B937 90 F4                 BCC   @1                       ;Loop if not done
0055 B939
0056 B939 A9 FF                 LDA   #$FF                     ;$FF out rest of table
0057 B93B              @2       EQU   *
0058 B93B E0 A1                 CPX   #$A1                     ;Is it get to the burn-in params ?
0059 B93D D0 07                 BNE   @3                       ;BRA if not
0060 B93F AC 46 C0              LDY   DIAGTYPE                 ;Is burn-in on ?
0061 B942 10 02                 BPL   @3                       ;BRA if not
0062 B944 A2 C1                 LDX   #$C1                     ;Else skip over 32 bytes
0063 B946 9D C0 02     @3       STA   |BRAMBUFFER,X            ;Put in buffer
0064 B949 E8                    INX                            ;
0065 B94A D0 EF                 BNE   @2                       ;Loop til all $FF'ed out
0066 B94C
0067 B94C AB                    PLB                            ;Recall data bank
0068 B94D 28                    PLP                            ;Recall interrupt status
0069 B94E
0070 B94E
0071 B94E                                                      ; SEG $FF
0072 B94E              WRITEBR  EQU   *                        ;Write to BATTERYRAM routine
0073 B94E                                                      ; SEG $00
0074 B94E 08                    PHP                            ;Disable interrupts during write
0075 B94F 78                    SEI                            ;
0076 B950 8B                    PHB                            ;Save current data bank register
0077 B951 20 82 F8              JSR   DBTOE1                   ;Switch to bank E1
0078 B954 20 57 BA              JSR   CALCCHKSUM               ;Go calculate checksum
0079 B957 8E BC 03              STX   |BRAMCHKSUM1             ;'X' returns main checksum
0080 B95A 8D BE 03              STA   |BRAMCHKSUM2             ;'A' returns secondary checksum
0081 B95D E2 30                 SEP   #$30                     ;'m'/'x' back to 8 bit land
0082 B95F A2 00                 LDX   #$00                     ;Start with 1st byte
0083 B961 9B                    TXY                            ;Start with address 00
0084 B962              @1       EQU   *
0085 B962 B8                    CLV                            ;Clear 'v' for write
0086 B963 BD C0 02              LDA   |BRAMBUFFER,X            ;
0087 B966 20 6F BA              JSR   XTNDBRAM                 ;
0088 B969 E8                    INX                            ;
0089 B96A C8                    INY                            ;Next address
0090 B96B D0 F5                 BNE   @1                       ;
0091 B96D AB                    PLB                            ;Restore data bank register
0092 B96E 28                    PLP                            ;Restore interrupt status
0093 B96F 6B                    RTL                            ;Make callable from anywhere with JSL
0094 B970
0095 B970                                                      ; SEG $FF
0096 B970              READBR   EQU   *                        ;Read from BATTERYRAM routine
0097 B970                                                      ; SEG $00
0098 B970 8B                    PHB                            ;Save current data bank register
0099 B971 08                    PHP                            ;Disable interrupts during write
0100 B972 78                    SEI                            ;
0101 B973 20 82 F8              JSR   DBTOE1                   ;Switch to bank E1
0102 B976 A2 00                 LDX   #$00                     ;Start with 1st byte
0103 B978 9B                    TXY                            ;Start with address 00
0104 B979              @1       EQU   *
0105 B979 E2 40                 SEP   #$40                     ;Set V for read
0106 B97B 20 6F BA              JSR   XTNDBRAM                 ;Read a byte
0107 B97E 9D C0 02              STA   |BRAMBUFFER,X            ;Save for later
0108 B981
0109 B981 E0 29                 CPX   #NLANGOP+0-NPORTOP       ;Number of languages available?
0110 B983 F0 1C                 BEQ   @16_3                    ;
0111 B985 E0 2A                 CPX   #NLANGOP+1-NPORTOP       ;Number of layouts available?
0112 B987 F0 1C                 BEQ   @16_5                    ;
0113 B989 E0 36                 CPX   #NRAMDSKOP+0-NPORTOP     ;Is it minimum RAM disk size?
0114 B98B F0 2C                 BEQ   @18                      ;No limit checking needed
0115 B98D E0 37                 CPX   #NRAMDSKOP+1-NPORTOP     ;Is it maximum RAM disk size?
0116 B98F F0 28                 BEQ   @18                      ;No limit checking needed
0117 B991 E0 3E                 CPX   #NCLOCKOP-NPORTOP        ;Test special if above this value
0118 B993 B0 06                 BCS   @16                      ;
0119 B995 DF 71 83 FF           CMP   >BRAMLIMITS,X            ;Test read value against max allowable
0120 B999 80 1C                 BRA   @17                      ;'c'=0 then it's an OK value
0121 B99B
0122 B99B              @16      EQU   *
0123 B99B D0 0C                 BNE   @16_6                    ;<>=8
0124 B99D C9 09                 CMP   #9                       ;'c'=0 then all's file
0125 B99F 80 16                 BRA   @17                      ;Exit routine
0126 B9A1
0127 B9A1              @16_3    EQU   *
0128 B9A1 C9 08                 CMP   #8                       ;
0129 B9A3 80 12                 BRA   @17                      ;Exit routine
0130 B9A5
0131 B9A5              @16_5    EQU   *
0132 B9A5 C9 11                 CMP   #17                      ;0-16 is OK for number of layouts
0133 B9A7 80 0E                 BRA   @17                      ;Exit routine
0134 B9A9
0135 B9A9              @16_6    EQU   *
0136 B9A9 E0 59                 CPX   #NCLOCKOP-NPORTOP+9+18   ;Limit+1 is 16
0137 B9AB B0 0C                 BCS   @18                      ;>= 83 then no limit checking is done
0138 B9AD E0 58                 CPX   #NCLOCKOP-NPORTOP+9+17   ;CHK new slot1 value
0139 B9AF 90 04                 BCC   @18_8                    ;BRA if not
0140 B9B1 C9 04                 CMP   #$04                     ;New slot1 value <=$03
0141 B9B3 80 02                 BRA   @17                      ;Exit routine
0142 B9B5              @18_8    EQU   *
0143 B9B5 C9 20                 CMP   #32                      ;
0144 B9B7              @17      EQU   *
0145 B9B7 B0 17                 BCS   READBRBAD                ;'c'=1 here then bad BATTERYRAM
0146 B9B9
0147 B9B9              @18      EQU   *
0148 B9B9 E8                    INX                            ;Next
0149 B9BA C8                    INY                            ;Next address
0150 B9BB D0 BC                 BNE   @1                       ;Loop til done
0151 B9BD 20 57 BA              JSR   CALCCHKSUM               ;Go calculate checksum
0152 B9C0 EC BC 03              CPX   |BRAMCHKSUM1             ;'X' returns main checksum
0153 B9C3 D0 0B                 BNE   READBRBAD                ;No match then exit with error
0154 B9C5 CD BE 03              CMP   |BRAMCHKSUM2             ;'A' returns secondary checksum
0155 B9C8 D0 06                 BNE   READBRBAD                ;No match then exit with error
0156 B9CA 28                    PLP                            ;Restore interrupt status
0157 B9CB 18                    CLC                            ;Data intact indicator
0158 B9CC E2 30                 SEP   #$30                     ;'m'/'x' back to 8 bit land
0159 B9CE AB                    PLB                            ;Restore data bank register
0160 B9CF 6B                    RTL                            ;Make callable from anywhere with JSL
0161 B9D0
0162 B9D0              READBRBAD EQU   *                       ;Set carry if data corrupt
0163 B9D0 E2 30                 SEP   #$30                     ;'m'/'x' back to 8 bit land
0164 B9D2 22 25 B9 FF           JSL   >WRITESTD                ;Try to write out standards if here
0165 B9D6 28                    PLP                            ;Restore interrupt status
0166 B9D7 38                    SEC                            ;Data is Apple standards indicator
0167 B9D8 AB                    PLB                            ;Restore data bank register
0168 B9D9 6B                    RTL                            ;Make callable from anywhere with JSL
0169 B9DA
0170 B9DA
0171 B9DA                                                      ; SEG $FF
0172 B9DA              READTIME EQU   *
0173 B9DA                                                      ; SEG $00
0174 B9DA 08                    PHP                            ;Disable interrupts during read
0175 B9DB 78                    SEI                            ;
0176 B9DC 8B                    PHB                            ;Save data bank register
0177 B9DD 20 82 F8              JSR   DBTOE1                   ; and switch it to bank E1
0178 B9E0 9C E0 03              STZ   |TIMEOUT                 ;Restart time out counter
0179 B9E3
0180 B9E3              @11      EQU   *
0181 B9E3 A0 00                 LDY   #$00                     ;Loop counter
0182 B9E5
0183 B9E5              @22      EQU   *
0184 B9E5 EE E0 03              INC   |TIMEOUT                 ;Test if timed out
0185 B9E8 F0 2C                 BEQ   READTIME8                ;Quit if can't read clock properly
0186 B9EA A2 00                 LDX   #$00                     ;Read 4 bytes
0187 B9EC A9 FD                 LDA   #$01-$04                 ;Starting address-4
0188 B9EE              @33      EQU   *
0189 B9EE 18                    CLC                            ;Next address
0190 B9EF 69 04                 ADC   #4                       ;
0191 B9F1 48                    PHA                            ;
0192 B9F2 09 80                 ORA   #$80                     ;Set bit 7 for reading command
0193 B9F4 E2 40                 SEP   #$40                     ;'v'=1 for reading clock chip
0194 B9F6 20 9F BA              JSR   WRITE1BYTE+1             ;Read data and disable transfer
0195 B9F9 C0 00                 CPY   #$00                     ;Test if 1st/2nd time through loop here
0196 B9FB D0 05                 BNE   @1                       ;<>0 then 2nd time through loop
0197 B9FD 9D E1 03              STA   |CLKRDATA,X              ;Store clock data 1st time through
0198 BA00 80 08                 BRA   @2                       ;
0199 BA02
0200 BA02              @1       EQU   *
0201 BA02 DD E1 03              CMP   |CLKRDATA,X              ;Test for match
0202 BA05 F0 03                 BEQ   @2                       ;= then continue normally
0203 BA07 68                    PLA                            ;Clean up stack
0204 BA08 80 D9                 BRA   @11                      ;And try again
0205 BA0A
0206 BA0A              @2       EQU   *
0207 BA0A 68                    PLA                            ;Recall 'A'
0208 BA0B E8                    INX                            ;
0209 BA0C E0 04                 CPX   #$04                     ;Read 4 bytes then all done
0210 BA0E 90 DE                 BCC   @33                      ;Loop til 4 bytes read
0211 BA10 BB                    TYX                            ;Test if 1st/2nd time through loop
0212 BA11 D0 07                 BNE   READTIME9                ;
0213 BA13 C8                    INY                            ;Indicate 2nd time through loop
0214 BA14 80 CF                 BRA   @22                      ;
0215 BA16
0216 BA16              READTIME8 EQU   *                       ;Write exits at READTIME8+1
0217 BA16 AB                    PLB                            ;Restore data bank register
0218 BA17 28                    PLP                            ;Restore interrupt status
0219 BA18                                                      ; SEG $FF
0220 BA18              SECRTL   EQU   *
0221 BA18                                                      ; SEG $00
0222 BA18 38                    SEC                            ;Indicate unable to read clock
0223 BA19 6B                    RTL                            ;Make callable from anywhere with JSL
0224 BA1A
0225 BA1A              READTIME9 EQU   *                       ;Write exits at READTIME9+1
0226 BA1A AB                    PLB                            ;Restore data bank register
0227 BA1B 28                    PLP                            ;Restore interrupt status
0228 BA1C                                                      ; SEG $FF
0229 BA1C              CLCRTL   EQU   *
0230 BA1C                                                      ; SEG $00
0231 BA1C 18                    CLC                            ;Indicate able to read clock
0232 BA1D 6B                    RTL                            ;Make callable from anywhere with JSL
0233 BA1E
0234 BA1E
0235 BA1E                                                      ; SEG $FF
0236 BA1E              WRITETIME EQU   *
0237 BA1E                                                      ; SEG $00
0238 BA1E 08                    PHP                            ;Disable interrupts during write
0239 BA1F 78                    SEI                            ;
0240 BA20 A9 00                 LDA   #$00                     ;Counter on stack
0241 BA22              @4       EQU   *
0242 BA22 48                    PHA                            ;
0243 BA23 A2 00                 LDX   #$00                     ;Write 4 bytes
0244 BA25 A9 FD                 LDA   #$01-$04                 ;Starting address-4
0245 BA27              @1       EQU   *
0246 BA27 18                    CLC                            ;Next address
0247 BA28 69 04                 ADC   #4                       ;
0248 BA2A 48                    PHA                            ;
0249 BA2B BF E5 03 E1           LDA   >CLKWDATA,X              ;Time to set clock to
0250 BA2F A8                    TAY                            ;Data to 'Y' for WRITE1BYTE
0251 BA30 A3 01                 LDA   1,S                      ;'A' = address to write to
0252 BA32 20 9E BA              JSR   WRITE1BYTE               ;Do it
0253 BA35 68                    PLA                            ;Recall 'A'
0254 BA36 E8                    INX                            ;
0255 BA37 E0 04                 CPX   #$04                     ;If at 4 then done
0256 BA39 90 EC                 BCC   @1                       ;Loop til 'c'=1
0257 BA3B
0258 BA3B 22 DA B9 FF           JSL   >READTIME                ;Read back/verify data written is correct
0259 BA3F
0260 BA3F A2 03                 LDX   #$03                     ;Test 4 bytes
0261 BA41              @2       EQU   *
0262 BA41 BF E1 03 E1           LDA   >CLKRDATA,X              ;Test data read
0263 BA45 DF E5 03 E1           CMP   >CLKWDATA,X              ; against data written
0264 BA49 D0 06                 BNE   @3                       ;<> = then rewrite clock data
0265 BA4B CA                    DEX                            ;Try next value
0266 BA4C 10 F3                 BPL   @2                       ;
0267 BA4E 68                    PLA                            ;All matched if here so exit
0268 BA4F 80 CA                 BRA   READTIME9+1              ;Exit indicating all's fine
0269 BA51
0270 BA51              @3       EQU   *
0271 BA51 68                    PLA                            ;Decrement counter
0272 BA52 3A                    DEC   A                        ;
0273 BA53 D0 CD                 BNE   @4                       ;Try again if timeout not reached
0274 BA55 80 C0                 BRA   READTIME8+1              ;Exit indicating error in write
0275 BA57
0276 BA57
0277 BA57              CALCCHKSUM EQU   *                      ;Calc checksum of BRAM from $00 to $FB
0278 BA57 A2 FA                 LDX   #$FA                     ;Checksum all BRAM except checksum bytes
0279 BA59 C2 20                 REP   #$20                     ;'m'=16 bit -- 'x'=8 bit
0280 BA5B                       LONGA ON
0281 BA5B 18                    CLC                            ;Clear carry to start
0282 BA5C A9 00 00              LDA   #$0000                   ;Start with $0000 as checksum
0283 BA5F              @1       EQU   *
0284 BA5F 2A                    ROL   A                        ;16 bit shift
0285 BA60 7D C0 02              ADC   |BRAMBUFFER,X            ;Add in value from buffer
0286 BA63 CA                    DEX                            ;
0287 BA64 E0 FF                 CPX   #$FF                     ;Stop on 'X'=$FF
0288 BA66 D0 F7                 BNE   @1                       ;Loop til done
0289 BA68 C2 30                 REP   #$30                     ;'m'/'x' = 16 bit mode
0290 BA6A AA                    TAX                            ;Save checksum 1 in 'X'
0291 BA6B 49 AA AA              EOR   #CHKSMCNST               ;Exclusive OR result with constant
0292 BA6E                       LONGA OFF
0293 BA6E 60                    RTS                            ;Exit 'X'=main chksum - 'A'=2nd chksum
0294 BA6F
0295 BA6F
0296 BA6F              * 'A' contains data to to write / from read
0297 BA6F              * 'Y' contains address to read/write data to
0298 BA6F              * BATTERYRAM address is in the form sssaaaaa
0299 BA6F              *            where sss is sector number (0-7)
0300 BA6F              *            and aaaaa is address (0-1F)
0301 BA6F              * 'v' contains read/write status
0302 BA6F              *     1 = read
0303 BA6F              *     0 = write
0304 BA6F              * 'X' is preserved
0305 BA6F
0306 BA6F              XTNDBRAM EQU   *                        ;Set up command and extended address
0307 BA6F 48                    PHA                            ;Save data to write to clock data register
0308 BA70 98                    TYA                            ;Create extended address
0309 BA71 48                    PHA                            ;Save for later
0310 BA72 29 E0                 AND   #$E0                     ;Get sector data
0311 BA74 4A                    LSR   A                        ;Move to bits 0,1,2
0312 BA75 4A                    LSR   A                        ;
0313 BA76 4A                    LSR   A                        ;
0314 BA77 4A                    LSR   A                        ;
0315 BA78 4A                    LSR   A                        ;
0316 BA79 09 38                 ORA   #EXMEMCMD                ;Sets command correctly
0317 BA7B 50 02                 BVC   @1                       ;'v' = 0 then writing
0318 BA7D 09 80                 ORA   #$80                     ;Modify command for reading
0319 BA7F
0320 BA7F              @1       EQU   *
0321 BA7F EB                    XBA                            ;Move in hi byte of 'A'
0322 BA80 68                    PLA                            ;Recall address
0323 BA81 29 1F                 AND   #$1F                     ;Strip off sector bits
0324 BA83 0A                    ASL   A                        ;Shift bits to 2 to 6
0325 BA84 0A                    ASL   A                        ;
0326 BA85 EB                    XBA                            ;Save address/do command
0327 BA86 08                    PHP                            ;Save user read/write status
0328 BA87 20 A3 BA              JSR   ACCCLKCLV                ;Transfer command to clock chip
0329 BA8A EB                    XBA                            ;Send address to write to, to clock chip
0330 BA8B              XTNDBRAM6 EQU   *
0331 BA8B 20 A3 BA              JSR   ACCCLKCLV                ;Transfer extended address to clock chip
0332 BA8E 28                    PLP                            ;Recall what user wants to do
0333 BA8F 68                    PLA                            ;Recall user data if writing
0334 BA90 20 A4 BA              JSR   ACCCLOCK                 ;Read/write a byte of data
0335 BA93 48                    PHA                            ;Save 'A'
0336 BA94 AD 34 C0              LDA   CLOCKCTL                 ;Reset bit
0337 BA97 29 DF                 AND   #$DF                     ;
0338 BA99 8D 34 C0              STA   CLOCKCTL                 ;
0339 BA9C 68                    PLA                            ;Recall 'A'
0340 BA9D 60                    RTS                            ;Back to caller
0341 BA9E
0342 BA9E
0343 BA9E              WRITE1BYTE EQU   *
0344 BA9E B8                    CLV                            ;'v'=0 to write data
0345 BA9F 5A                    PHY                            ;Save data to write on stack
0346 BAA0 08                    PHP                            ;Save read/write status on stack
0347 BAA1 80 E8                 BRA   XTNDBRAM6                ;
0348 BAA3
0349 BAA3
0350 BAA3              ACCCLKCLV EQU   *                       ;Write a byte of data to the clock chip
0351 BAA3 B8                    CLV                            ;'v'=0 to write data
0352 BAA4              ACCCLOCK EQU   *                        ;Send a byte of data to the clock chip
0353 BAA4 8D 33 C0              STA   CLOCKDATA                ;Data/address/cmd to clock data register
0354 BAA7 AD 34 C0              LDA   CLOCKCTL                 ;Reset read/write bit
0355 BAAA 29 3F                 AND   #$3F                     ;Bit 7/6 to 0
0356 BAAC 70 04                 BVS   @0                       ;'v' = 1 if reading instead of writing
0357 BAAE 09 A0                 ORA   #$A0                     ;Bit 7/5 to 1 to write transfer
0358 BAB0 80 02                 BRA   @1                       ;
0359 BAB2
0360 BAB2              @0       EQU   *                        ;Doing read of BATTERYRAM if here
0361 BAB2 09 E0                 ORA   #$E0                     ;Enable transfer for reading
0362 BAB4              @1       EQU   *
0363 BAB4 8D 34 C0              STA   CLOCKCTL                 ;
0364 BAB7              @2       EQU   *                        ;Wait til transaction is done
0365 BAB7 AD 34 C0              LDA   CLOCKCTL                 ;Wait for transfer to complete
0366 BABA 30 FB                 BMI   @2                       ;Loop til done
0367 BABC AD 33 C0              LDA   CLOCKDATA                ;Put data in 'A' and exit
0368 BABF 60                    RTS                            ;All's fine if here
0369 BAC0
0370 BAC0
0371 BAC0
0372 BAC0
0373 BAC0                       TITLE 'BATTERYRAM/Clock Chip Rtnes2'
0374 BAC0
0375 BAC0              ******************************************************
0376 BAC0              *                                                    *
0377 BAC0              *              BATTERYRAM/Clock Routines2            *
0378 BAC0              *                                                    *
0379 BAC0              *                    by                              *
0380 BAC0              *               Fern Bachman     1985-1987           *
0381 BAC0              *               Joe Bo           1987-1989           *
0382 BAC0              *                                                    *
0383 BAC0              *       Copyright Apple Computer, Inc. 1985-1989     *
0384 BAC0              *                All Rights Reserved.                *
0385 BAC0              *                                                    *
0386 BAC0              ******************************************************
0387 BAC0
0388 BAC0
0389 BAC0                                                      ; SEG $FF
0390 BAC0              MICROABORTED EQU   *                    ;Int handler goes here on micro abort
0391 BAC0                                                      ; SEG $00
0392 BAC0 AF 35 01 E1           LDA   >CURSOR                  ;Save cursor around JSR SETUPBR
0393 BAC4 48                    PHA                            ;
0394 BAC5 20 CF BA              JSR   SETUPBR                  ;Go resync with keyboard micro
0395 BAC8 68                    PLA                            ;Restore CURSOR
0396 BAC9 8F 35 01 E1           STA   >CURSOR                  ;
0397 BACD 18                    CLC                            ;Back to interrupt handler 'c'=0 if
0398 BACE 6B                    RTL                            ; micro is back on line else system death.
0399 BACF
0400 BACF
0401 BACF              * SETUPBR does several things for the system.
0402 BACF              *
0403 BACF              * NOTE: Interrupts are off on entry to here
0404 BACF              *
0405 BACF              *     1. Read BATTERYRAM
0406 BACF              *     2. If an error then write default parameters
0407 BACF              *        to BRAMBUFFER and write that to BATTERYRAM.
0408 BACF              *     3. Pre-modify APTALKBOOT byte so that 'SLOOP' routine
0409 BACF              *        can have enough space to handle booting from AppleTalk
0410 BACF              *     4. Setup system to user preferences except for
0411 BACF              *        system speed which must be done in Apple//e
0412 BACF              *        monitor space.
0413 BACF              *
0414 BACF
0415 BACF              SETUPBR  EQU   *
0416 BACF A9 0B                 LDA   #11                      ;Change register 11 in the SCC
0417 BAD1 8D 39 C0              STA   SCCAREG                  ; to enable the oscillator.
0418 BAD4 A9 D2                 LDA   #$D2                     ;Monitor is only one allowed to do this
0419 BAD6 8D 39 C0              STA   SCCAREG                  ; of channel B will stop working.
0420 BAD9 20 3B 9B              JSR   RESETFF                  ;Setup some reset stuff
0421 BADC 22 70 B9 FF           JSL   >READBR                  ;Move BATTERYRAM params to buffer in E1
0422 BAE0 8B                    PHB                            ;Save data bank register
0423 BAE1 20 82 F8              JSR   DBTOE1                   ;Change data bank to E1
0424 BAE4
0425 BAE4 9C C0 01              STZ   |APTALKPORT              ;0=NONE, 1=PORT1, 2=PORT2
0426 BAE7 9C C1 01              STZ   |APTALKBOOT              ;0=NONE, 1=$C100, 2=$C200 .....
0427 BAEA 9C C2 01              STZ   |APTALKRPMM              ;Remote printing, same as APTALKBOOT
0428 BAED AD E2 02              LDA   |USERSLT2                ;Is slot 2 for AppleTalk ?
0429 BAF0 C9 02                 CMP   #$02                     ;0=Printer, 1=Modem, 2=AppleTalk
0430 BAF2 F0 08                 BEQ   @2                       ;Set APTALKBOOT=2, boot from slot2
0431 BAF4              @1       EQU   *
0432 BAF4 AD 18 03              LDA   |SPCLSLT1                ;Is slot 1 for AppleTalk? Use real one !!
0433 BAF7 C9 02                 CMP   #$02                     ;
0434 BAF9 D0 0A                 BNE   @3                       ;Bra if both slot1/2 not for ApTalk  
0435 BAFB 3A                    DEC   A                        ;Make it 1=boot from slot1 AppleTalk
0436 BAFC              @2       EQU   *
0437 BAFC 8D C0 01              STA   |APTALKPORT              ;Set up APTALKPORT
0438 BAFF 8D C1 01              STA   |APTALKBOOT              ;0=NONE, 1=Slot1 ApTalk, 2=Slot2 ApTalk
0439 BB02 8D C2 01              STA   |APTALKRPMM              ;Set remote printing stuff
0440 BB05
0441 BB05              @3       EQU   *
0442 BB05 A2 07                 LDX   #$07                     ;Save 8 bytes
0443 BB07              @4       EQU   *                        ;Save flush/micro abort vectors
0444 BB07 BD 4C 00              LDA   |IRQ_FLUSH,X             ;Pick up byte
0445 BB0A 48                    PHA                            ;Save on stack
0446 BB0B CA                    DEX                            ;
0447 BB0C 10 F9                 BPL   @4                       ;Loop til done
0448 BB0E
0449 BB0E 20 62 7F              JSR   RESETFDB                 ;Wake up front desk bus
0450 BB11
0451 BB11
0452 BB11 20 62 7F              JSR   RESETFDB                 ;Wake up front desk bus again
0453 BB14
0454 BB14 A2 00                 LDX   #$00                     ;Restore 8 bytes
0455 BB16              @12      EQU   *                        ;Save flush/micro abort vectors
0456 BB16 68                    PLA                            ;Recall byte
0457 BB17 9D 4C 00              STA   |IRQ_FLUSH,X             ;Pick up byte
0458 BB1A E8                    INX                            ;
0459 BB1B E0 08                 CPX   #$08                     ;Increment to 8 the quit
0460 BB1D D0 F7                 BNE   @12                      ;Loop til done
0461 BB1F
0462 BB1F AB                    PLB                            ;Restore data bank register
0463 BB20 AF A6 01 E1           LDA   >CLRHOLES                ;
0464 BB24 D0 27                 BNE   @13                      ;BRA not to clear
0465 BB26 A9 FF                 LDA   #$FF                     ;Set it non-zero
0466 BB28 8F A6 01 E1           STA   >CLRHOLES                ;Set it non zero
0467 BB2C              ;REP #$30 ;16-bit mode to clear screen holes
0468 BB2C              ;MEMORY16  ; so that slinky ram card would work
0469 BB2C              ;INDEX16  ; it can't be clear with $a0 !!!
0470 BB2C              ;LDA #$0000 ;Clean all screen holes to zero
0471 BB2C              ;LDX #$0006 ;Index to screen holes
0472 BB2C A9 00                 LDA   #$00
0473 BB2E A2 08                 LDX   #$08
0474 BB30              @14      EQU   *
0475 BB30 CA                    DEX   
0476 BB31 F0 1A                 BEQ   @13
0477 BB33 9D 78 04              STA   $478,X                   ;DO IT
0478 BB36 9D F8 04              STA   $4F8,X
0479 BB39 9D 78 05              STA   $578,X
0480 BB3C 9D F8 05              STA   $5F8,X
0481 BB3F 9D 78 06              STA   $678,X
0482 BB42 9D F8 06              STA   $6F8,X
0483 BB45 9D 78 07              STA   $778,X
0484 BB48 9D F8 07              STA   $7F8,X
0485 BB4B 80 E3                 BRA   @14
0486 BB4D              ;DEX
0487 BB4D              ;CPX #$0001
0488 BB4D              ;BNE @14
0489 BB4D              ;DEX
0490 BB4D              ;BPL @14
0491 BB4D              ;SEP #$30
0492 BB4D              ;MEMORY8
0493 BB4D              ;INDEX8
0494 BB4D              @13      EQU   *
0495 BB4D 20 71 BB              JSR   TSTPWRUP                 ;Test power up bytes
0496 BB50 D0 09                 BNE   ITSCLDST                 ;= then it's warmstart
0497 BB52 AF 39 01 E1           LDA   >SLOTSFLG                ;What was set up before?
0498 BB56 20 CA BB              JSR   SETUPSLOTS1              ;Set up 80 columns correctly NOW!!!!
0499 BB59 38                    SEC                            ;Do NOT setup slots on warmstart
0500 BB5A 90                    OPCODE BCC
0501 BB5B
0502 BB5B              ITSCLDST EQU   *
0503 BB5B 18                    CLC                            ;Set up slots if coldstart
0504 BB5C 22 7A BB FF           JSL   >USERSETUP               ;Do rest of setup
0505 BB60
0506 BB60              * Test if warm or cold startup.  If warmstart make
0507 BB60              * warmstart reset call to tool dispatcher.
0508 BB60
0509 BB60 20 71 BB              JSR   TSTPWRUP                 ;Test power up bytes
0510 BB63 D0 0B                 BNE   @4                       ;<>= then it's coldstart
0511 BB65
0512 BB65                       IF IS512 <> 0 THEN 
0513 BB65                       ELSE 
0514 BB65 C2 30                 REP   #$30                     ;Warm start the tool locator/tools
0515 BB67                       LONGI ON
0516 BB67 A2 01 05              LDX   #$0501                   ;Warmstart/tool locator call
0517 BB6A                       LONGI OFF
0518 BB6A 22 00 00 E1           JSL   >DISPATCH1               ;Call it
0519 BB6E E2 30                 SEP   #$30                     ;Back to normal monitor mode
0520 BB70                       ENDIF 
0521 BB70
0522 BB70              @4       EQU   *
0523 BB70 60                    RTS                            ;Back to caller
0524 BB71
0525 BB71              TSTPWRUP EQU   *                        ;Test for warmstart or coldstart
0526 BB71 AD F3 03              LDA   SOFTEV+1                 ;Is reset Hi byte
0527 BB74 49 A5                 EOR   #$A5                     ; a funny complement of the
0528 BB76 CD F4 03              CMP   PWREDUP                  ; power up byte?
0529 BB79 60                    RTS                            ;'z'=0 if warmstart else its coldstart
0530 BB7A
0531 BB7A              * USERSETUP is called via a vector called TOBRAMSETUP
0532 BB7A              * in bank E1.
0533 BB7A              *  Entry requirements:
0534 BB7A              *                      Native mode 8 bit 'm'/'x'
0535 BB7A              *                      'c'=0 for complete setup
0536 BB7A              *                      'c'=1 for setup all except slots
0537 BB7A
0538 BB7A                                                      ; SEG $FF
0539 BB7A              USERSETUP EQU   *                       ;Setup called by control panel
0540 BB7A                                                      ; SEG $00
0541 BB7A 08                    PHP                            ;Save interrupt status
0542 BB7B 78                    SEI                            ;NO interrupts in here
0543 BB7C AD 68 C0              LDA   STATEREG                 ;Save state
0544 BB7F 48                    PHA                            ;Save on stack
0545 BB80 29 FE                 AND   #$FE                     ;Enable slotcsrom space
0546 BB82 09 08                 ORA   #$08                     ;Enable ROM
0547 BB84 8D 68 C0              STA   STATEREG                 ;
0548 BB87 08                    PHP                            ;'c'=0 then change everything possible
0549 BB88 20 D7 BB              JSR   SETUPBR2                 ;Set up some BATTERYRAM stuff
0550 BB8B 28                    PLP                            ;'c'=1 if do NOT change slots designation
0551 BB8C B0 03                 BCS   @1                       ;
0552 BB8E 20 9B BB              JSR   SETUPSLOTS               ;Set up slots stuff (int versus ext)
0553 BB91              @1       EQU   *
0554 BB91 20 E2 F9              JSR   D2D                      ;Detect disk ]['s / set up system speed
0555 BB94 68                    PLA                            ;Recall state
0556 BB95 8D 68 C0              STA   STATEREG                 ; and restore it.
0557 BB98 28                    PLP                            ;Recall interrupt status
0558 BB99 18                    CLC                            ;Needed for keyboard micro abort interrupt
0559 BB9A 6B                    RTL                            ;Back to external caller
0560 BB9B
0561 BB9B                                                      ; SEG $FF
0562 BB9B              SETUPSLOTS EQU   *                      ;Set up slot designation (int versus ext)
0563 BB9B                                                      ; SEG $00
0564 BB9B A2 07                 LDX   #$7                      ;Shift 7 times
0565 BB9D A9 00                 LDA   #$00                     ;Starting SLTROMSEL value
0566 BB9F              @1       EQU   *
0567 BB9F 1F E0 02 E1           ORA   >USERSLT1-1,X            ;Or in next slot
0568 BBA3 0A                    ASL   A                        ;Shift 1 bit
0569 BBA4 CA                    DEX                            ;
0570 BBA5 D0 F8                 BNE   @1                       ;Loop til done
0571 BBA7 29 F0                 AND   #$F0                     ;Bits 3,2,1 and 0 MUST be 0
0572 BBA9 AA                    TAX                            ;Save 'A'
0573 BBAA AF E2 02 E1           LDA   >USERSLT2                ;Whose slot 2 card ?
0574 BBAE C9 01                 CMP   #$01                     ;Is it set to external ?
0575 BBB0 D0 04                 BNE   @2                       ;BRA if not
0576 BBB2 8A                    TXA                            ;Get back 'A'
0577 BBB3 09 04                 ORA   #$04                     ;Set slot 2 to external, bit2
0578 BBB5 AA                    TAX                            ;Save 'A' again
0579 BBB6              @2       EQU   *
0580 BBB6 AF 18 03 E1           LDA   >SPCLSLT1                ;Whose slot 1 card ? Use real one
0581 BBBA C9 01                 CMP   #$01                     ;Is it set to external ?
0582 BBBC D0 04                 BNE   @3                       ;BRA if not 
0583 BBBE 8A                    TXA                            ;Get back 'A'
0584 BBBF 09 02                 ORA   #$02                     ;Set slot 1 to external, bit0
0585 BBC1 AA                    TAX                            ;Make it for next instruction
0586 BBC2              @3       EQU   *
0587 BBC2 8A                    TXA                            ;Get back 'A'
0588 BBC3 8D 2D C0              STA   SLTROMSEL                ;Now set up slot ROM select switch
0589 BBC6 8F 39 01 E1           STA   >SLOTSFLG                ;Used to set up SLTROMSEL on warm reset
0590 BBCA                                                      ; SEG $FF
0591 BBCA              SETUPSLOTS1 EQU   *                     ;Set up 80 columns correctly
0592 BBCA                                                      ; SEG $00
0593 BBCA 8D 0A C0              STA   SETINTC3ROM              ;Enable internal slot 3 $Cn00 space
0594 BBCD AF E3 02 E1           LDA   >USERSLT3                ;Whose slot 3 card?
0595 BBD1 F0 03                 BEQ   @1                       ;= then internal slot 3 $Cn00 active
0596 BBD3 8D 0B C0              STA   SETSLOTC3ROM             ;Enable external slot 3 $Cn00 space
0597 BBD6
0598 BBD6              @1       EQU   *
0599 BBD6 60                    RTS                            ;Back to caller
0600 BBD7
0601 BBD7
0602 BBD7              SETUPBR2 EQU   *                        ;Entry point for control panel
0603 BBD7 22 70 B9 FF           JSL   >READBR                  ;Move BATTERYRAM params to buffer in E1
0604 BBDB
0605 BBDB 8B                    PHB                            ;Change data bank register to E1
0606 BBDC 20 82 F8              JSR   DBTOE1                   ;
0607 BBDF 9C 8F 01              STZ   |ORGMEMORY               ;Zero out for monitor commands
0608 BBE2 18                    CLC                            ;Carry must be clear to start
0609 BBE3 AD E0 02              LDA   |USERSPEED               ;
0610 BBE6 6A                    ROR   A                        ;Shift to hi bit to make mask
0611 BBE7 6A                    ROR   A                        ;Bit7=1 for hi spd - bit7=0 for slow spd
0612 BBE8 8D 38 01              STA   |SYSTEMSPD               ;
0613 BBEB
0614 BBEB 20 0E BC              JSR   SETCOLORS                ;Set up all color related stuff
0615 BBEE
0616 BBEE AD 3C C0              LDA   SOUNDCTL                 ;Change low nybble only
0617 BBF1 29 F0                 AND   #$F0                     ;
0618 BBF3 0D DE 02              ORA   |USERVOL                 ;What's user volume?
0619 BBF6 8D 3C C0              STA   SOUNDCTL                 ;Alter user's volume
0620 BBF9 AD DE 02              LDA   |USERVOL                 ;Set up IRQ volumne
0621 BBFC 8D CA 00              STA   |IRQ_VOLUME              ; for interrupt manager
0622 BBFF 0A                    ASL   A                        ;Move to hi nybble for Ensoniq routines
0623 BC00 0A                    ASL   A                        ;
0624 BC01 0A                    ASL   A                        ;
0625 BC02 0A                    ASL   A                        ;
0626 BC03 8D B0 1D              STA   |SYSVOLLOC               ;Save for Ensoniq sound routines
0627 BC06 20 EA C3              JSR   FIXCURSHIFTER            ;Fix up flash rate for cursor
0628 BC09
0629 BC09
0630 BC09              * Sync up to the keyboard microprocessor.
0631 BC09              *    and place them in BRAMBUFFER.
0632 BC09              * Finally setup all micro parameters including
0633 BC09              *    1. Keyboard buffering
0634 BC09              *    2. Shift Caps/Lower Case
0635 BC09              *    3. Fast Space/Bkspace Keys
0636 BC09              *    4. Dual Speed
0637 BC09              *    5. High Mouse Resolution
0638 BC09
0639 BC09
0640 BC09 20 83 80              JSR   |PANELFDB                ;Go to front desk bus code to set up stuff
0641 BC0C AB                    PLB                            ;Restore data bank register
0642 BC0D 60                    RTS                            ;Back to caller
0643 BC0E
0644 BC0E
0645 BC0E              SETCOLORS EQU   *
0646 BC0E 8B                    PHB                            ;Save data bank register
0647 BC0F 20 82 F8              JSR   DBTOE1                   ;Switch to bank E1
0648 BC12 AD DA 02              LDA   |USERTEXT                ;Make up text/background as user wants
0649 BC15 0A                    ASL   A                        ;Lo byte to hi byte
0650 BC16 0A                    ASL   A                        ;
0651 BC17 0A                    ASL   A                        ;
0652 BC18 0A                    ASL   A                        ;
0653 BC19 0D DB 02              ORA   |USERBACK                ;
0654 BC1C 8D 22 C0              STA   TBCOLOR                  ;Sets text/background bits
0655 BC1F
0656 BC1F AD 34 C0              LDA   CLOCKCTL                 ;Mask off lo nybble
0657 BC22 29 F0                 AND   #$F0                     ;
0658 BC24 0D DC 02              ORA   |USERBORDER              ;
0659 BC27 8D 34 C0              STA   CLOCKCTL                 ;
0660 BC2A
0661 BC2A A9 F0                 LDA   #$F0                     ;Mask out bits 4,5,6,7
0662 BC2C 1C 2B C0              TRB   LANGSEL                  ;
0663 BC2F AD E9 02              LDA   |USERDISP                ;User display language
0664 BC32 0A                    ASL   A                        ;Shift left 1 byte to make room for hertz
0665 BC33 0D DD 02              ORA   |USERHERTZ               ;Set up user clock frequency
0666 BC36 0A                    ASL   A                        ;Shift to bit4 for masking
0667 BC37 0A                    ASL   A                        ;
0668 BC38 0A                    ASL   A                        ;
0669 BC39 0A                    ASL   A                        ;
0670 BC3A 09 08                 ORA   #$08                     ;Enable character select bit in Mega //
0671 BC3C 0C 2B C0              TSB   LANGSEL                  ;Bit4=0/1 (60hz/50hz)
0672 BC3F
0673 BC3F A9 20                 LDA   #$20                     ;Reset bit
0674 BC41 1C 29 C0              TRB   NEWVIDEO                 ; before setting it correctly
0675 BC44 18                    CLC                            ;MUST clear carry or unknown results
0676 BC45 AD D8 02              LDA   |USERCOLOR               ;Make up color/mono for user
0677 BC48 6A                    ROR   A                        ;Move to bit 7
0678 BC49 6A                    ROR   A                        ;
0679 BC4A 8D 21 C0              STA   MONOCOLOR                ;Sets up mono/color for user
0680 BC4D 6A                    ROR   A                        ;Shift to bit 5 for NEWVIDEO mask
0681 BC4E 6A                    ROR   A                        ;
0682 BC4F 0C 29 C0              TSB   NEWVIDEO                 ;Sets color/mono for double hires
0683 BC52 AB                    PLB                            ;Restore data bank register
0684 BC53 60                    RTS                            ;Back to caller
0685 BC54
0686 BC54
0687 BC54
0688 BC54
0689 BC54                       TITLE 'Interrupt Handlers ROM Code'
0690 BC54
0691 BC54              ******************************************************
0692 BC54              *                                                    *
0693 BC54              *    Interrupt Handler/Manager ROM code routines     *
0694 BC54              *                                                    *
0695 BC54              *                    by                              *
0696 BC54              *               Rich Williams     1985-1987          *
0697 BC54              *               Fern Bachman      1985-1987          *
0698 BC54              *               Joe Bo            1987-1989          *
0699 BC54              *                                                    *
0700 BC54              *       Copyright Apple Computer, Inc. 1985-1989     *
0701 BC54              *                All Rights Reserved.                *
0702 BC54              *                                                    *
0703 BC54              ******************************************************
0704 BC54
0705 BC54
0706 BC54              ******************************************************
0707 BC54              *
0708 BC54              * CPABRTDISP arbitrates whether the interrupt was
0709 BC54              * from an ABORT or a COP occurring.
0710 BC54              *
0711 BC54              ******************************************************
0712 BC54
0713 BC54                                                      ; SEG $FF
0714 BC54              CPABRTDISP EQU   *                      ;COP/ABORT dispatcher
0715 BC54                                                      ; SEG $00
0716 BC54 90 04                 BCC   @1                       ;'c'=0 if it's a COP of some kind
0717 BC56 5C 18 00 E1           JMP   >ABORTMGRV               ;'c'=1 it's an abort
0718 BC5A
0719 BC5A              @1       EQU   *
0720 BC5A 5C 14 00 E1           JMP   >COPMGRV                 ;'c'=0 it's a COP
0721 BC5E
0722 BC5E
0723 BC5E              ******************************************************
0724 BC5E              *
0725 BC5E              * Here 'v'=? 'b'=? from COP instruction.  In here
0726 BC5E              * dummy up processor status from COP to make it look
0727 BC5E              * like a break (native or emulation) occurred for
0728 BC5E              * display of the COP message.  For emulation mode
0729 BC5E              * this requires clearing 'v' and by pulling the COP
0730 BC5E              * status from the stack, setting the 'b' bit and pushing
0731 BC5E              * the status back on the stack and falling
0732 BC5E              * into Rich's interrupt code.  For native mode this
0733 BC5E              * requires setting 'v'=1 to indicate a native
0734 BC5E              * mode COP.
0735 BC5E              *
0736 BC5E              ******************************************************
0737 BC5E
0738 BC5E                                                      ; SEG $FF
0739 BC5E              UABORTHNDLR EQU   *                     ;Unknown aborts come here
0740 BC5E              UCOPHNDLR EQU   *                       ;Unknown aborts come here
0741 BC5E                                                      ; SEG $00
0742 BC5E 18                    CLC                            ;Which type of COP (emulation or native)?
0743 BC5F FB                    XCE                            ;Switch 'e' and 'c'
0744 BC60 B0 04                 BCS   @1                       ;'c' set then it was emulation mode COP
0745 BC62 E2 40                 SEP   #$40                     ;Set 'v' to simulate native mode break
0746 BC64 80 06                 BRA   INTHNDLR                 ;Go to normal interrupt handler
0747 BC66
0748 BC66                                                      ; SEG $FF
0749 BC66              @1       EQU   *                        ;Unknown emulation mode COP handler
0750 BC66                                                      ; SEG $00
0751 BC66 FB                    XCE                            ;Switch back to emulation mode
0752 BC67 B8                    CLV                            ;Indicates not a native break
0753 BC68 68                    PLA                            ;Change COP status to simulate a break
0754 BC69 09 10                 ORA   #$10                     ;Set break bit
0755 BC6B 48                    PHA                            ;
0756 BC6C
0757 BC6C
0758 BC6C              ***********************************************
0759 BC6C              *
0760 BC6C              * Here V=1 if break =0 if don't know yet
0761 BC6C              * Save A,X,Y,DB and E bit
0762 BC6C              * and shadow reg and cya register
0763 BC6C              * Set native mode, fast speed, C = E bit
0764 BC6C              *
0765 BC6C              ***********************************************
0766 BC6C
0767 BC6C                                                      ; SEG $FF
0768 BC6C              INTHNDLR EQU   *
0769 BC6C                                                      ; SEG $00
0770 BC6C 18                    CLC                            ;Into native mode
0771 BC6D FB                    XCE   
0772 BC6E C2 30                 REP   #M8+X8                   ;16 bit regs
0773 BC70                       LONGA ON
0774 BC70 08                    PHP                            ;Save emulation status
0775 BC71 8B                    PHB                            ;Save data bank
0776 BC72 F4 E1 E1              PEA   $E1E1                    ;Set data bank to E1
0777 BC75 AB                    PLB   
0778 BC76 8D 08 01              STA   |irq_A                   ;Save the A reg
0779 BC79 AD 35 C0              LDA   SHADOW                   ;Get shadow and cya
0780 BC7C 8D 19 01              STA   |irq_shadow              ;Save em
0781 BC7F 09 00 80              ORA   #$8000                   ;Force fast speed
0782 BC82 29 3E 9F              AND   #$9F3E                   ;Force I/O and text shadowing
0783 BC85 8D 35 C0              STA   SHADOW
0784 BC88 8E 0A 01              STX   |irq_X                   ;Save X & Y
0785 BC8B 8C 0C 01              STY   |irq_Y
0786 BC8E 7B                    TDC                            ;Save direct register
0787 BC8F 8D 10 01              STA   |irq_D                   ;
0788 BC92 A9 00 00              LDA   #$0000                   ;Reset direct register to $0000
0789 BC95 5B                    TCD                            ;
0790 BC96
0791 BC96
0792 BC96                       LONGA OFF
0793 BC96 E2 30                 SEP   #$30
0794 BC98              *
0795 BC98              * A patch was added here to preserve the alternate pg 1 stack which
0796 BC98              *  was not preserved in the earlier ROMs.  This patch added too many
0797 BC98              *  cycles into the path from interrupt to the AppleTalk data stores
0798 BC98              *  below and so was pulled out.  The load/store is moved to three
0799 BC98              *  different places that are not in this initial, critical path.
0800 BC98              *  {MSA/FAB 4/14/89}
0801 BC98              *
0802 BC98              ;LDA =ALEMSTKPTR ;Store emulation stack pointer
0803 BC98              ;STA irq_EMULSTKPTR ;
0804 BC98
0805 BC98              * Do a quick break test before testing for SCC interrupt.
0806 BC98
0807 BC98 90 06                 BCC   @1                       ;'c'=0 then maybe native mode interrupt
0808 BC9A A3 04                 LDA   4,S                      ;Recall status byte
0809 BC9C 29 10                 AND   #$10                     ;Test emulation mode break bit
0810 BC9E 69 70                 ADC   #$70                     ;Add $10 or $11 to set 'v'
0811 BCA0              @1       EQU   *
0812 BCA0 70 74                 BVS   @222                     ;'v'=1 on breaks
0813 BCA2
0814 BCA2              * End of quick break test.
0815 BCA2
0816 BCA2
0817 BCA2 A9 03                 LDA   #$03                     ;Test register 3 for interrupt
0818 BCA4 8D 39 C0              STA   SCCAREG                  ;
0819 BCA7 AD 39 C0              LDA   SCCAREG                  ;=0 then not an SCC interrupt
0820 BCAA 2C 03 01              BIT   |SCCFLAG2                ;Interrupt mask for AppleTalk
0821 BCAD F0 37                 BEQ   @122                     ;
0822 BCAF 48                    PHA                            ;Save for serial interrupt testing
0823 BCB0 29 07                 AND   #$07                     ;$38=channel A mask - $07=channel B mask
0824 BCB2 D0 12                 BNE   @2                       ;Do channel B for AppleTalk
0825 BCB4
0826 BCB4              * Fall through for channel A AppleTalk interrupt
0827 BCB4
0828 BCB4 AD 3B C0              LDA   SCCADATA                 ;Read channel A
0829 BCB7 8D 05 01              STA   |SCC1                    ;Save as data byte 1
0830 BCBA AD 3B C0              LDA   SCCADATA                 ;Read next byte too
0831 BCBD 8D 06 01              STA   |SCC2                    ;Save as data byte 2
0832 BCC0 22 20 00 E1           JSL   >IRQ_APTLK               ;Process AppleTalk interrupt
0833 BCC4 80 10                 BRA   @121                     ;Skip channel B read
0834 BCC6
0835 BCC6              * Branch (BNE) to here for channel B AppleTalk interrupt
0836 BCC6
0837 BCC6              @2       EQU   *
0838 BCC6 AD 3A C0              LDA   SCCBDATA                 ;Read channel B
0839 BCC9 8D 05 01              STA   |SCC1                    ;Save as data byte 1
0840 BCCC AD 3A C0              LDA   SCCBDATA                 ;Read next byte too
0841 BCCF 8D 06 01              STA   |SCC2                    ;Save as data byte 2
0842 BCD2 22 20 00 E1           JSL   >IRQ_APTLK               ;Process AppleTalk interrupt
0843 BCD6
0844 BCD6              @121     EQU   *
0845 BCD6 AF 01 01 01           LDA   >ALEMSTKPTR              ;{MSA/FAB 4/14/89} Preserve page 1 stack pointer
0846 BCDA 8D 1C 01              STA   |IRQ_EMULSTKPTR          ;{MSA/FAB 4/14/89}
0847 BCDD A9 00                 LDA   #$00                     ;Save user gets called or not status
0848 BCDF 6A                    ROR   A                        ;Move 'c' into status byte
0849 BCE0 8D 01 01              STA   |SCCSTAT                 ;
0850 BCE3 68                    PLA                            ;Recall SCC interrupt status
0851 BCE4 80 13                 BRA   @123                     ;Skip reseting of SCCSTAT
0852 BCE6
0853 BCE6              @122     EQU   *
0854 BCE6 48                    PHA                            ;{MSA/FAB 4/14/89} Keep SCCAREG around
0855 BCE7 AF 01 01 01           LDA   >ALEMSTKPTR              ;{MSA/FAB 4/14/89} Preserve page 1 stack pointer
0856 BCEB 8D 1C 01              STA   |IRQ_EMULSTKPTR          ;{MSA/FAB 4/14/89}
0857 BCEE 9C 01 01              STZ   |SCCSTAT                 ;MUST 0 this status byte out here
0858 BCF1
0859 BCF1 22 1C 02 E1           JSL   >IRQ_MIDI                ;Polls for midi input int
0860 BCF5 68                    PLA                            ;{MSA/FAB 4/14/89} Recover SCCAREG!
0861 BCF6 90 14                 BCC   @123_7                   ;BRA if Midi claims the int
0862 BCF8              *
0863 BCF8              * The following clear carry is inserted to maintain compatibility
0864 BCF8              *  in the case that the MIDI interrupt handler refuses the interrupt.
0865 BCF8              *  The carry was clear at this point in the 01 ROM and some app's
0866 BCF8              *  interrupt handlers depend on the the carry being clear on entry
0867 BCF8              *  to the handler (Master Tracks just does a PHP / PLP in the sound
0868 BCF8              *  handler; it always services the interrupt when installed and
0869 BCF8              *  assumed that what the carry was at entry was okay to return
0870 BCF8              *  on exit...)  3/23/89  MSA
0871 BCF8              *
0872 BCF8 18                    CLC   
0873 BCF9
0874 BCF9              @123     EQU   *
0875 BCF9 48                    PHA                            ;Preserve SCC register 3 interrupt status
0876 BCFA 2D 04 01              AND   |SERFLAG                 ;Test for serial interrupts
0877 BCFD F0 13                 BEQ   @124                     ;=0 then no serial interrupts
0878 BCFF 22 24 00 E1           JSL   >IRQ_SERIAL              ;Go to serial interrupt handler
0879 BD03 6E 01 01              ROR   |SCCSTAT                 ;Save user gets called or not status
0880 BD06 68                    PLA                            ;Clean up stack to exit this way
0881 BD07              @123_5   EQU   *
0882 BD07 AD 01 01              LDA   |SCCSTAT                 ;Test for <>=0
0883 BD0A D0 09                 BNE   @125                     ;ROR yields 'z'<>1 then bug user
0884 BD0C
0885 BD0C              @123_7   EQU   *
0886 BD0C C2 30                 REP   #$30                     ;16 bit land a must
0887 BD0E AB                    PLB                            ;Clean up stack
0888 BD0F 4C 58 BF              JMP   IRQDONE4                 ;Exit quickly
0889 BD12
0890 BD12              @124     EQU   *
0891 BD12 68                    PLA                            ;What was SCC register 3 interrupt status?
0892 BD13 D0 F2                 BNE   @123_5                   ;<>=0 then chk to see if user gets called
0893 BD15
0894 BD15              @125     EQU   *
0895 BD15 B8                    CLV                            ;
0896 BD16
0897 BD16
0898 BD16                       LONGA ON
0899 BD16              @222     EQU   *
0900 BD16 AF 01 01 01           LDA   >ALEMSTKPTR              ;{MSA/FAB 4/14/89} Preserve page 1 stack pointer
0901 BD1A 8D 1C 01              STA   |IRQ_EMULSTKPTR          ;{MSA/FAB 4/14/89}
0902 BD1D C2 30                 REP   #$30                     ;16 bit land a must
0903 BD1F AB                    PLB                            ;Clean up stack
0904 BD20 68                    PLA   
0905 BD21 8D 13 01              STA   |irq_DB                  ;Save data bank and em status
0906 BD24 9C C3 00              STZ   |IRQ_INTFLAG             ;Reset IRQ_INTFLAG/IRQ_DATAREG
0907 BD27 9C C5 00              STZ   |IRQ_KMSTATUS            ;Reset IRQ_KMSTATUS/IRQ_SECFLAG
0908 BD2A
0909 BD2A              ********************************************
0910 BD2A              *
0911 BD2A              * Test for break here so stack information
0912 BD2A              * can be saved with the correct stack 
0913 BD2A              * in place.
0914 BD2A              *
0915 BD2A              *******************************************
0916 BD2A
0917 BD2A 50 1E                 BVC   @4                       ;
0918 BD2C E2 10                 SEP   #$10                     ;16 bit 'm' but 8 bit 'x'
0919 BD2E 7A                    PLY                            ;Recall break processor status
0920 BD2F 5A                    PHY                            ;Put back on stack for possible restart
0921 BD30 8C 12 01              STY   |irq_P                   ;Save for break printout/'R'esume
0922 BD33 84 48                 STY   STATUS                   ;Save for old break users
0923 BD35 A3 02                 LDA   2,S                      ;Recall PCL/PCH
0924 BD37 8D 16 01              STA   |irq_PC                  ;Save for break printout/'R'esume
0925 BD3A 85 3A                 STA   PCL                      ;Save for old break users
0926 BD3C A0 00                 LDY   #$00                     ;Anticipate bank 00 is break bank
0927 BD3E AD 14 01              LDA   |irq_DB+1                ;Bit 0=1 if emulation mode break
0928 BD41 4A                    LSR   A                        ;Bit 0 to 'c'
0929 BD42 B0 03                 BCS   @3                       ;
0930 BD44 A3 04                 LDA   4,S                      ;Recall break bank
0931 BD46 A8                    TAY                            ;Move to 8 bit 'Y' to save bank number
0932 BD47              @3       EQU   *
0933 BD47 8C 15 01              STY   |irq_K                   ;Save for break printout/'R'esume
0934 BD4A
0935 BD4A              @4       EQU   *
0936 BD4A
0937 BD4A              ***********************************************
0938 BD4A              *
0939 BD4A              * Now fix the stack pointer
0940 BD4A              *
0941 BD4A              ***********************************************
0942 BD4A 3B                    TSC   
0943 BD4B 8D 0E 01              STA   |irq_S                   ;Save the stack pointer
0944 BD4E E2 30                 SEP   #M8+X8                   ;8 bit land
0945 BD50                       LONGA OFF
0946 BD50 EB                    XBA                            ;A = stack hi
0947 BD51 49 01                 EOR   #1                       ;Page 1?
0948 BD53 D0 0A                 BNE   @5                       ;
0949 BD55 AE 16 C0              LDX   rdaltzp                  ;Alternate stack? (do NOT change 'v')
0950 BD58 10 0D                 BPL   @6
0951 BD5A EB                    XBA                            ;
0952 BD5B 8F 01 01 01           STA   >ALEMSTKPTR              ;Save the alternate stack pointer
0953 BD5F              @5       EQU   *
0954 BD5F A9 01                 LDA   #$01                     ;
0955 BD61 EB                    XBA                            ;
0956 BD62 AF 00 01 01           LDA   >MNEMSTKPTR              ;Get main stack pointer
0957 BD66 1B                    TCS                            ;Into the stack with it
0958 BD67
0959 BD67              ***********************************************
0960 BD67              *
0961 BD67              * Now set the state register to the standard state
0962 BD67              *
0963 BD67              ***********************************************
0964 BD67              @6       EQU   *
0965 BD67 AD 68 C0              LDA   statereg
0966 BD6A 8D 18 01              STA   |irq_state               ;Save the current value
0967 BD6D AE 18 C0              LDX   rd80col                  ;If 80store, get page 1 (leave 'v' alone)
0968 BD70 10 02                 BPL   @7
0969 BD72 29 BF                 AND   #$BF
0970 BD74              @7       EQU   *
0971 BD74 29 40                 AND   #$40                     ;
0972 BD76 09 08                 ORA   #$08                     ;Enable ROM
0973 BD78 8D 68 C0              STA   STATEREG
0974 BD7B
0975 BD7B              *
0976 BD7B              * At this point we have
0977 BD7B              * A,X,Y,DB saved
0978 BD7B              * State, shadow and CYA registers saved
0979 BD7B              * Standard state and fast speed set
0980 BD7B              * V = 1 if Break
0981 BD7B              *
0982 BD7B
0983 BD7B AF F8 07 00           LDA   >$000000+mslot           ;Get mslot
0984 BD7F 8D 1B 01              STA   |irq_mslot               ;Push on stack?
0985 BD82 50 06                 BVC   @8                       ;'v'=0 then test for internal interrupt
0986 BD84 9C C6 00              STZ   |IRQ_SECFLAG             ;Be sure it's 0
0987 BD87 4C 99 BF              JMP   irqbrk1                  ;If BRK, skip internal irq handlers
0988 BD8A
0989 BD8A
0990 BD8A
0991 BD8A              ***********************************************
0992 BD8A              *
0993 BD8A              * Built in interrupt handlers should be put here
0994 BD8A              * All registers are 8 bits on entry to here
0995 BD8A              *
0996 BD8A              ***********************************************
0997 BD8A
0998 BD8A
0999 BD8A              @8       EQU   *
1000 BD8A EE CB 00              INC   |IRQ_ACTIVE              ;<>0 then indicate irq's active
1001 BD8D AD 01 01              LDA   |SCCSTAT                 ;=0 then not SCC irq
1002 BD90 F0 0A                 BEQ   @9                       ;<>0 then it's an SCC problem
1003 BD92 8D C6 00              STA   |IRQ_SECFLAG             ;Causes multiple interrupts to be handled
1004 BD95 A9 00                 LDA   #$00                     ;Change data bank register to $00
1005 BD97 48                    PHA                            ;
1006 BD98 AB                    PLB                            ; before quitting.
1007 BD99 4C 8F BF              JMP   IRQDONE1_1               ;Exit with SCC interrupt processed
1008 BD9C
1009 BD9C              @9       EQU   *
1010 BD9C A9 00                 LDA   #$00                     ;Data bank register to 00
1011 BD9E 48                    PHA                            ;
1012 BD9F AB                    PLB                            ;
1013 BDA0 AD 23 C0              LDA   VGCINT                   ;Test for scan line interrupt
1014 BDA3 10 0F                 BPL   @22                      ;+ then not a VGC interrupt
1015 BDA5 29 22                 AND   #$22                     ;Bit 5=status - bit 1=enable
1016 BDA7 4A                    LSR   A                        ;Shift bit 1 into carry
1017 BDA8 4A                    LSR   A                        ;
1018 BDA9 90 09                 BCC   @22                      ;'c'=0 then not enabled
1019 BDAB F0 07                 BEQ   @22                      ;'z'=0 then not a scan line interrupt
1020 BDAD 22 28 00 E1           JSL   >IRQ_SCAN                ;<>0 then try to service interrupt
1021 BDB1 4C FD BE              JMP   @77_6                    ;Exit this way
1022 BDB4
1023 BDB4              @22      EQU   *
1024 BDB4
1025 BDB4              * Save and restore Ensoniq state
1026 BDB4
1027 BDB4 AD 3C C0              LDA   SOUNDCTL                 ;Save control state too
1028 BDB7 29 F0                 AND   #$F0                     ;Strip off unstable nybble
1029 BDB9 48                    PHA                            ;
1030 BDBA C2 30                 REP   #$30                     ;Do this fast to save time
1031 BDBC AD 3E C0              LDA   SOUNDADRL                ;
1032 BDBF 48                    PHA                            ;Save sound address in use
1033 BDC0 E2 30                 SEP   #$30                     ;Back to normal monitor mode
1034 BDC2 A9 E0                 LDA   #$E0                     ;Oscillator Interrupt Register (OIR)
1035 BDC4 8D 3E C0              STA   SOUNDADRL                ;Set in address lo byte of sound glu
1036 BDC7 AD 3C C0              LDA   SOUNDCTL                 ;What's current hi nybble?
1037 BDCA 29 90                 AND   #$90                     ;Enable reading Ensoniq DOC / Auto inc off
1038 BDCC 0F CA 00 E1           ORA   >IRQ_VOLUME              ;Or in volume nybble
1039 BDD0 8D 3C C0              STA   SOUNDCTL                 ;
1040 BDD3 AD 3D C0              LDA   SOUNDDATA                ;False read to sound glu
1041 BDD6 AD 3D C0              LDA   SOUNDDATA                ;Reads OIR
1042 BDD9 8F CC 00 E1           STA   >IRQ_SOUNDDATA           ;Save for sound tools
1043 BDDD 30 17                 BMI   @33                      ;'-' then not sound interrupt
1044 BDDF 22 2C 00 E1           JSL   >IRQ_SOUND               ;'+' then it's a sound interrupt
1045 BDE3 C2 30                 REP   #$30                     ;Do this fast to save time
1046 BDE5 68                    PLA                            ;Recall sound address in use
1047 BDE6 8D 3E C0              STA   SOUNDADRL                ;
1048 BDE9 E2 30                 SEP   #$30                     ;Back to normal monitor mode
1049 BDEB 68                    PLA                            ;Recall sound control state
1050 BDEC 0F CA 00 E1           ORA   >IRQ_VOLUME              ;Or in volume nybble
1051 BDF0 8D 3C C0              STA   SOUNDCTL                 ; and restore it.
1052 BDF3 4C FD BE              JMP   @77_6                    ;Exit this way
1053 BDF6
1054 BDF6              @33      EQU   *
1055 BDF6 C2 30                 REP   #$30                     ;Do this fast to save time
1056 BDF8 68                    PLA                            ;Recall sound address in use
1057 BDF9 8D 3E C0              STA   SOUNDADRL                ;
1058 BDFC E2 30                 SEP   #$30                     ;Back to normal monitor mode
1059 BDFE 68                    PLA                            ;Recall sound control state
1060 BDFF 0F CA 00 E1           ORA   >IRQ_VOLUME              ;Or in volume nybble
1061 BE03 8D 3C C0              STA   SOUNDCTL                 ; and restore it.
1062 BE06 AD 46 C0              LDA   INTFLAG                  ;Get VBL/qtr sec int status
1063 BE09 2D 41 C0              AND   INTEN                    ;Only enabled active ints will be 1 now
1064 BE0C 8F C3 00 E1           STA   >IRQ_INTFLAG             ;
1065 BE10 29 18                 AND   #$18                     ;Bit 4=1/4 sec int - -bit 3=VBL
1066 BE12 48                    PHA                            ;Save for qtr sec testing later
1067 BE13 29 08                 AND   #$08                     ;VBL status is bit 3
1068 BE15 F0 1A                 BEQ   @33_2                    ;=0 then not a VBL interrupt
1069 BE17 22 30 00 E1           JSL   >IRQ_VBL                 ;Go to routine to service VBL
1070 BE1B AF D7 00 E1           LDA   >IRQ_MOUSVBL             ;Test if user gets VBLs
1071 BE1F D0 0C                 BNE   @33_0                    ;<>= then mouse gets VBLs
1072 BE21 90 0E                 BCC   @33_2                    ;
1073 BE23 A9 08                 LDA   #$08                     ;Reset VBL interrupts if no one wants them
1074 BE25 1C 41 C0              TRB   INTEN                    ;
1075 BE28 8D 47 C0              STA   CLRVBLINT                ;Arbitrarily turn off VBL int
1076 BE2B 80 04                 BRA   @33_2                    ;Skip setting flag
1077 BE2D
1078 BE2D              @33_0    EQU   *
1079 BE2D 38                    SEC                            ;Forces interrupt to user
1080 BE2E 20 83 BF              JSR   TSTSETFLG                ;Set flag to guarantee VBL to user
1081 BE31
1082 BE31              @33_2    EQU   *
1083 BE31 AD 27 C0              LDA   KMSTATUS                 ;Save status for later testing
1084 BE34 8F C5 00 E1           STA   >IRQ_KMSTATUS            ;
1085 BE38 0A                    ASL   A                        ;See if mousey type interrupt
1086 BE39 10 0C                 BPL   @44                      ;Mouse interrupts not enabled
1087 BE3B 90 0A                 BCC   @44                      ;+ then mouse ints enabled but not active
1088 BE3D 22 34 00 E1           JSL   >IRQ_MOUSE               ;Go try to do mouse interrupt
1089 BE41 B8                    CLV                            ;Mouse interrupt
1090 BE42
1091 BE42 20 83 BF              JSR   TSTSETFLG                ;Check 'c' and maybe set flag
1092 BE45 80 02                 BRA   @44_1                    ;Skip setting 'v'
1093 BE47
1094 BE47              @44      EQU   *
1095 BE47 E2 40                 SEP   #$40                     ;'v'=1 if not serviced or not mouse int
1096 BE49              @44_1    EQU   *
1097 BE49 68                    PLA                            ;Recall INTFLAG status
1098 BE4A D0 04                 BNE   @44_2                    ;<>= then try qtr sec int status flag
1099 BE4C 50 75                 BVC   @66_8                    ;'v'=0 then no more to test for
1100 BE4E 70 0A                 BVS   @66                      ;Not VBL/qtr sec or mouse interrupt
1101 BE50
1102 BE50              @44_2    EQU   *
1103 BE50 29 10                 AND   #$10                     ;Bit 4 is qtr sec int status flag
1104 BE52 F0 6F                 BEQ   @66_8                    ;Not a qtr sec interrupt
1105 BE54 22 38 00 E1           JSL   >IRQ_QTR                 ;Go to routine to service interrupt
1106 BE58 80 66                 BRA   @66_6                    ;Exit this way
1107 BE5A
1108 BE5A              @66      EQU   *
1109 BE5A AF C5 00 E1           LDA   >IRQ_KMSTATUS            ;Test for data register interrupts
1110 BE5E 29 30                 AND   #$30                     ;Bits 4,5 are status/enable
1111 BE60 0A                    ASL   A                        ;Bit 5 to 'c'/bit 4 to bit 7
1112 BE61 0A                    ASL   A                        ;
1113 BE62 0A                    ASL   A                        ;
1114 BE63 10 61                 BPL   @55                      ;+ then not enabled
1115 BE65 90 5F                 BCC   @55                      ;'c'=0 then not data reg int
1116 BE67
1117 BE67 AD 26 C0              LDA   DATAREG                  ;Pick up DATAREG for testing now and later
1118 BE6A 8F C4 00 E1           STA   >IRQ_DATAREG             ;Save for later
1119 BE6E 10 07                 BPL   @66_1                    ;Not response byte interrupt
1120 BE70 22 40 00 E1           JSL   >IRQ_RESPONSE            ;Go do interrupt if possible
1121 BE74 20 83 BF              JSR   TSTSETFLG                ;Check 'c' and maybe set flag
1122 BE77
1123 BE77              @66_1    EQU   *
1124 BE77 AF C4 00 E1           LDA   >IRQ_DATAREG             ;Recall status byte
1125 BE7B 29 08                 AND   #$08                     ; and test for SRQ interrupt
1126 BE7D F0 07                 BEQ   @66_2                    ;=0 then not an SRQ
1127 BE7F 22 44 00 E1           JSL   >IRQ_SRQ                 ;Go do interrupt if possible
1128 BE83 20 83 BF              JSR   TSTSETFLG                ;Check 'c' and maybe set flag
1129 BE86
1130 BE86              @66_2    EQU   *
1131 BE86 AF C4 00 E1           LDA   >IRQ_DATAREG             ;Recall status byte
1132 BE8A 29 20                 AND   #$20                     ; and test for desktop mgr interrupt
1133 BE8C F0 13                 BEQ   @66_3                    ;=0 then not an desktop mgr interrupt
1134 BE8E AD 25 C0              LDA   KEYMODREG                ;Is Shift key pressed also ?
1135 BE91 6A                    ROR   A                        ;Rotate bit0 (shift) to 'c'
1136 BE92 90 06                 BCC   @66_2_1                  ;BRA if not pressed with Shift key
1137 BE94 22 08 00 FE           JSL   >TODESKMGR               ;Else use private vector to jmp to
1138 BE98 80 04                 BRA   @66_2_3                  ;Continue on  
1139 BE9A              @66_2_1  EQU   *
1140 BE9A 22 48 00 E1           JSL   >IRQ_DSKACC              ;Go do interrupt if possible
1141 BE9E              @66_2_3  EQU   *
1142 BE9E 20 83 BF              JSR   TSTSETFLG                ;Check 'c' and maybe set flag
1143 BEA1
1144 BEA1              @66_3    EQU   *
1145 BEA1 AF C4 00 E1           LDA   >IRQ_DATAREG             ;Recall status byte
1146 BEA5 29 50                 AND   #$50                     ; and test for flush buffer interrupt
1147 BEA7 0A                    ASL   A                        ;Shift bit 6 to carry
1148 BEA8 0A                    ASL   A                        ;
1149 BEA9 F0 09                 BEQ   @66_4                    ;=0 then not flush buffer interrupt
1150 BEAB 90 03                 BCC   @66_2_2                  ;'c' clear then don't clear KBDSTRB
1151 BEAD 8D 10 C0              STA   KBDSTRB                  ;Remove key in buffer
1152 BEB0              @66_2_2  EQU   *
1153 BEB0 22 4C 00 E1           JSL   >IRQ_FLUSH               ;Go do interrupt if possible
1154 BEB4
1155 BEB4              @66_4    EQU   *
1156 BEB4 AF C4 00 E1           LDA   >IRQ_DATAREG             ;Recall status byte
1157 BEB8 C9 40                 CMP   #$40                     ; and test for keyboard micro interrupt
1158 BEBA D0 07                 BNE   @66_8                    ;= then abort interrupt
1159 BEBC 22 50 00 E1           JSL   >IRQ_MICRO               ;Go do interrupt if possible
1160 BEC0              @66_6    EQU   *
1161 BEC0 20 83 BF              JSR   TSTSETFLG                ;Check 'c' and maybe set flag
1162 BEC3              @66_8    EQU   *
1163 BEC3 4C 8F BF              JMP   IRQDONE1_1               ;See if we exit or go to OS int handler
1164 BEC6
1165 BEC6              @55      EQU   *
1166 BEC6 AF C5 00 E1           LDA   >IRQ_KMSTATUS            ;Test for keyboard interrupt
1167 BECA A8                    TAY                            ;Save for later
1168 BECB 29 0C                 AND   #$0C                     ;Bit 2= key int enable- bit3=key int
1169 BECD 4A                    LSR   A                        ;
1170 BECE 4A                    LSR   A                        ;
1171 BECF 4A                    LSR   A                        ;'c' = enable - 'z' = key int
1172 BED0 90 08                 BCC   @77_0                    ;'c' = 0 key ints not enabled
1173 BED2 F0 06                 BEQ   @77_0                    ;Not a keyboard interrupt
1174 BED4 22 3C 00 E1           JSL   >IRQ_KBD                 ;Go do interrupt if possible
1175 BED8 80 23                 BRA   @77_6                    ;Exit this way
1176 BEDA
1177 BEDA              @77_0    EQU   *
1178 BEDA AD 23 C0              LDA   VGCINT                   ;Test for 1 second interrupt
1179 BEDD 10 0E                 BPL   @77                      ;+ then not a VGC interrupt
1180 BEDF 29 44                 AND   #$44                     ;Bit 6=status - bit2=enable
1181 BEE1 0A                    ASL   A                        ;Shift status to 'c'
1182 BEE2 0A                    ASL   A                        ;
1183 BEE3 F0 08                 BEQ   @77                      ;=0 then 1 sec int not enabled
1184 BEE5 90 06                 BCC   @77                      ;'c'=0 then not a 1 second interrupt
1185 BEE7 22 54 00 E1           JSL   >IRQ_1SEC                ;Go do interrupt if possible
1186 BEEB 80 10                 BRA   @77_6                    ;Exit this way
1187 BEED
1188 BEED              @77      EQU   *
1189 BEED AD 23 C0              LDA   VGCINT                   ;Test for EXT interrupt from VGC
1190 BEF0 10 10                 BPL   @88                      ;+ then not a VGC interrupt
1191 BEF2 29 11                 AND   #$11                     ;Bit 4=status - Bit 0=enable
1192 BEF4 4A                    LSR   A                        ;
1193 BEF5 90 0B                 BCC   @88                      ;EXT interrupts not enabled
1194 BEF7 F0 09                 BEQ   @88                      ;=0 then not EXT interrupt
1195 BEF9 22 58 00 E1           JSL   >IRQ_EXT                 ;Go do interrupt if possible
1196 BEFD              @77_6    EQU   *
1197 BEFD 90 39                 BCC   IRQDONE2                 ;Exit with interrupt serviced
1198 BEFF 4C 98 BF              JMP   IRQBRK0                  ;Go to operating system to handle int
1199 BF02
1200 BF02              @88      EQU   *
1201 BF02 22 A9 01 E1           JSL   >DEFAULTSLT              ;Let OS patches for set default slot
1202 BF06
1203 BF06 22 5C 00 E1           JSL   >IRQ_OTHER               ;Is special interrupt handler installed?
1204 BF0A 80 F1                 BRA   @77_6                    ;Test 'c' flag
1205 BF0C                       EJECT 
1206 BF0C              ***********************************************
1207 BF0C              *
1208 BF0C              * irqdone1 - This restores the machine after a user's interrupt
1209 BF0C              * Assumes entry in emulation mode from user's interrupt
1210 BF0C              * Sets native mode, fast speed, DB=$E1
1211 BF0C              * Restores mslot, D
1212 BF0C              *
1213 BF0C              ***********************************************
1214 BF0C
1215 BF0C                                                      ; SEG $FF
1216 BF0C              IRQDONE1 EQU   *
1217 BF0C                                                      ; SEG $00
1218 BF0C
1219 BF0C 68                    PLA                            ;Pull RTL opcode from stack
1220 BF0D              IRQDONE1_2 EQU   *
1221 BF0D 18                    CLC                            ;Back to native mode
1222 BF0E FB                    XCE   
1223 BF0F 22 AD 01 E1           JSL   >RESTORSLT               ;Restore system slots assignment after user's int
1224 BF13 AF C6 00 E1           LDA   >IRQ_SECFLAG             ;Are we really done?
1225 BF17 0A                    ASL   A                        ;Remove 1 status bit
1226 BF18 8F C6 00 E1           STA   >IRQ_SECFLAG             ;Resave status byte
1227 BF1C D0 7A                 BNE   IRQBRK0                  ;Back through operating system if <>0
1228 BF1E
1229 BF1E              @1       EQU   *
1230 BF1E A9 80                 LDA   #$80                     ;Back to fast mode
1231 BF20 0C 36 C0              TSB   cyareg
1232 BF23 AF 1B 01 E1           LDA   >irq_mslot               ;Get mslot
1233 BF27 8D F8 07              STA   mslot                    ;Assumes data bank reg is $00 on entry
1234 BF2A C2 10                 REP   #X8
1235 BF2C EB                    XBA                            ;A = Cnxx
1236 BF2D A9 00                 LDA   #$00                     ;A = Cn00
1237 BF2F AA                    TAX   
1238 BF30 2C FF CF              BIT   CLRROM                   ;Deselect all C800s
1239 BF33 BD 00 00              LDA   |0000,x                  ;Access Cn00 to enable C800 space
1240 BF36 E2 10                 SEP   #X8                      ;Restore 'x' to 8 bit mode
1241 BF38
1242 BF38
1243 BF38
1244 BF38              ***********************************************
1245 BF38              *
1246 BF38              * irqdone2 - Fixes machine after internal interrupt
1247 BF38              * restores stack, data bank, Y, X ,A & E bit
1248 BF38              * and state, shadow & cya registers
1249 BF38              * Assumes 8 bit 'm' and 'x'
1250 BF38              *
1251 BF38              ***********************************************
1252 BF38
1253 BF38              IRQDONE2 EQU   *
1254 BF38 A9 E1                 LDA   #$E1                     ;Data bank register back to E1
1255 BF3A 48                    PHA                            ;
1256 BF3B AB                    PLB                            ;
1257 BF3C AD 8B C0              LDA   LCBANK1                  ;Write enable language card
1258 BF3F AD 8B C0              LDA   LCBANK1                  ;Write enable language card
1259 BF42 AD 18 01              LDA   |irq_state               ;Fix the state reg
1260 BF45 8D 68 C0              STA   STATEREG                 ;
1261 BF48 CE CB 00              DEC   |IRQ_ACTIVE              ;Indicate irq's no longer active
1262 BF4B C2 30                 REP   #M8+X8                   ;Go to 16 bit land
1263 BF4D 9C C3 00              STZ   |IRQ_INTFLAG             ;Zero out 2 bytes
1264 BF50 AD 0E 01              LDA   |irq_S                   ;And now the stack
1265 BF53 1B                    TCS   
1266 BF54 AD 13 01              LDA   |irq_db                  ;Data bank and E bit
1267 BF57 48                    PHA   
1268 BF58
1269 BF58              IRQDONE4 EQU   *
1270 BF58 AD 10 01              LDA   |irq_D                   ;Restore ZP
1271 BF5B 5B                    TCD   
1272 BF5C AC 0C 01              LDY   |irq_Y
1273 BF5F AE 0A 01              LDX   |irq_X
1274 BF62 AD 19 01              LDA   |irq_shadow              ;SHADOW and CYA
1275 BF65 8D 35 C0              STA   SHADOW
1276 BF68
1277 BF68 E2 20                 SEP   #$20                     ;8 bit 'm'
1278 BF6A AD 1C 01              LDA   |irq_emulstkptr          ;Restore emulation stk ptr
1279 BF6D 8F 01 01 01           STA   >alemstkptr              ;
1280 BF71
1281 BF71 20 2E 7A              JSR   SETTEXT2REG              ;Add in for protection
1282 BF74 C2 20                 REP   #$20                     ;Back to 16 bit 'm'
1283 BF76 AD 08 01              LDA   |irq_A                   ;A reg
1284 BF79
1285 BF79 AB                    PLB                            ;Data bank
1286 BF7A 28                    PLP                            ;'c' = 'e' bit
1287 BF7B B0 01                 BCS   @1                       ;Br if emulation
1288 BF7D 40                    RTI                            ;Bye bye
1289 BF7E              @1       EQU   *                        ;Must rti from bank 0
1290 BF7E FB                    XCE                            ;Switch to emulation mode first
1291 BF7F 5C 72 C0 00           JMP   >RTI~Bnk00               ;Must rti from bank 0
1292 BF83
1293 BF83
1294 BF83              TSTSETFLG EQU   *
1295 BF83 90 09                 BCC   @1                       ;No flag change if 'c'=0
1296 BF85 AF C6 00 E1           LDA   >IRQ_SECFLAG             ; else set a bit
1297 BF89 6A                    ROR   A                        ;Move 'c' to bit 7 of IRQ_SECFLAG
1298 BF8A 8F C6 00 E1           STA   >IRQ_SECFLAG             ;
1299 BF8E              @1       EQU   *
1300 BF8E 60                    RTS                            ;
1301 BF8F
1302 BF8F
1303 BF8F
1304 BF8F
1305 BF8F
1306 BF8F              ***********************************************
1307 BF8F              *
1308 BF8F              * Not an internal interrupt
1309 BF8F              * Save D and mslot
1310 BF8F              * Set D=0 DB=0 and slow speed
1311 BF8F              * and call user's handler
1312 BF8F              *
1313 BF8F              ***********************************************
1314 BF8F
1315 BF8F              IRQDONE1_1 EQU   *
1316 BF8F AF C6 00 E1           LDA   >IRQ_SECFLAG             ;Go to operating sys int handler
1317 BF93 D0 03                 BNE   IRQBRK0                  ;If <>0, then not yet done
1318 BF95 4C 0D BF              JMP   IRQDONE1_2               ; else end it and exit
1319 BF98              IRQBRK0  EQU   *
1320 BF98 B8                    CLV                            ;'v'=0 to indicate it's an int not break
1321 BF99              IRQBRK1  EQU   *
1322 BF99 A9 00                 LDA   #$00                     ;Change data bank
1323 BF9B 48                    PHA                            ;Set data bank to 0
1324 BF9C AB                    PLB   
1325 BF9D
1326 BF9D
1327 BF9D
1328 BF9D
1329 BF9D              * Added for protection
1330 BF9D
1331 BF9D AD 68 C0              LDA   statereg
1332 BFA0 AE 18 C0              LDX   rd80col                  ;If 80store, get page 1 (leave 'v' alone)
1333 BFA3 10 02                 BPL   @1                       ;
1334 BFA5 29 BF                 AND   #$BF
1335 BFA7              @1       EQU   *
1336 BFA7 29 40                 AND   #$40                     ;
1337 BFA9 09 08                 ORA   #$08                     ;Enable ROM
1338 BFAB 8D 68 C0              STA   STATEREG
1339 BFAE
1340 BFAE
1341 BFAE
1342 BFAE
1343 BFAE A9 80                 LDA   #$80
1344 BFB0 1C 36 C0              TRB   cyareg                   ;Slow speed
1345 BFB3 50 08                 BVC   @3                       ;'v'=0 then it's not a BRK
1346 BFB5 22 70 00 E1           JSL   >BREAKVECTOR             ;If it's a BRK see if something to do
1347 BFB9 90 D4                 BCC   IRQDONE1_1               ;
1348 BFBB
1349 BFBB              @2       EQU   *
1350 BFBB E2 40                 SEP   #$40                     ;Indicate BRK occurred
1351 BFBD
1352 BFBD              @3       EQU   *
1353 BFBD C2 20                 REP   #$20                     ;16 bit 'A' register needed
1354 BFBF 3B                    TSC                            ;Save stack pointer
1355 BFC0 A2 6B                 LDX   #$6B                     ;'RTL' opcode
1356 BFC2 DA                    PHX                            ;Put instruction on stack
1357 BFC3 4B                    PHK                            ;Put bank number of return addr on stack
1358 BFC4 F4 0B BF              PEA   |IRQDONE1-1              ;Push return address on stack
1359 BFC7 48                    PHA                            ;Push RTI return address on stack
1360 BFC8 38                    SEC                            ;Into emulation mode
1361 BFC9 FB                    XCE                            ;
1362 BFCA E2 20                 SEP   #$20                     ;8 bit 'm'
1363 BFCC A9 04                 LDA   #$04                     ;Disable interrupt's for user's RTI
1364 BFCE 48                    PHA                            ;
1365 BFCF 70 04                 BVS   @5                       ;Branch if break
1366 BFD1 5C 3D FD 00           JMP   >GOIRQ~Bnk00             ;Off to the user's handler
1367 BFD5
1368 BFD5              @5       EQU   *
1369 BFD5 AF 08 01 E1           LDA   >irq_A                   ;Move Accumulator
1370 BFD9 85 45                 STA   ACC                      ;
1371 BFDB AF 0A 01 E1           LDA   >irq_X                   ;Move 'X'
1372 BFDF 85 46                 STA   XREG                     ;
1373 BFE1 AF 0C 01 E1           LDA   >irq_Y                   ;Move 'Y'
1374 BFE5 85 47                 STA   YREG                     ;
1375 BFE7 AF 0E 01 E1           LDA   >irq_S                   ;Move stack pointer
1376 BFEB 85 49                 STA   SPNT                     ;
1377 BFED 38                    SEC                            ;Into emulation mode
1378 BFEE FB                    XCE                            ;
1379 BFEF 5C 56 FA 00           JMP   >GOBRK~Bnk00             ;Go do a break
1380 BFF3
1381 BFF3                       FillTo $C06E
1382 C06E              TOROMDSKACC EQU   *
1383 C06E 4C 36 9D              JMP   TSTMONDSKACC
1384 C071
1385 C071
1386 C071                       TITLE '15 Byte Interrupt ROM Code'
1387 C071
1388 C071              ******************************************************
1389 C071              *                                                    *
1390 C071              *         15 byte interrupt ROM code routines        *
1391 C071              *                                                    *
1392 C071              *                         by                         *
1393 C071              *                    Fern Bachman                    *
1394 C071              *                    Rich Williams                   *
1395 C071              *                                                    *
1396 C071              *       Copyright Apple Computer, Inc. 1985-1987     *
1397 C071              *                All Rights Reserved.                *
1398 C071              *                                                    *
1399 C071              ******************************************************
1400 C071
1401 C071              TONBREAK EQU   *                        ;Native mode breaks vector here
1402 C071              RTI~Bnk00 EQU   *+1-Rel~Org+Bnk~Org     ;RTI ($40) in C07x space
1403 C071 E2 40                 SEP   #$40                     ;Set 'v' to indicate from here
1404 C073 50                    OPCODE BVC
1405 C074
1406 C074              TONIRQ   EQU   *
1407 C074              TOEBRKIRQ EQU   *
1408 C074 B8                    CLV                            ;Indicate from here
1409 C075 5C 10 00 E1           JMP   >INTMGRV                 ;Enter interrupt handler
1410 C079
1411 C079              TONABORT EQU   *
1412 C079              TOEABORT EQU   *
1413 C079 38                    SEC                            ;'c'=1 if it's abort
1414 C07A 90                    OPCODE BCC
1415 C07B              TONCOP   EQU   *
1416 C07B              TOECOP   EQU   *
1417 C07B 18                    CLC                            ;'c'=0 if it's COP
1418 C07C 5C 54 BC FF           JMP   >CPABRTDISP              ;Go to COP/ABORT dispatcher
1419 C080
1420 C080                       TITLE 'Print Routine + New Cmds Table'
1421 C080
1422 C080              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
1423 C080              ;	by EdAsmCvtIIGS version 1.2d5 on 5/9/91 at 7:22:19 PM
1424 C080
1425 C080
1426 C080              ******************************************************
1427 C080              *                                                    *
1428 C080              *           Firmware Print Messages Routines         *
1429 C080              *                                                    *
1430 C080              *                         by                         *
1431 C080              *                    Fern Bachman                    *
1432 C080              *                                                    *
1433 C080              *       Copyright Apple Computer, Inc. 1985-1987     *
1434 C080              *                All Rights Reserved.                *
1435 C080              *                                                    *
1436 C080              ******************************************************
1437 C080
1438 C080
1439 C080              * PRINTMSG and PRINTMSG2 are used by the monitor,
1440 C080              * control panel program, disk routines, and via
1441 C080              * hooks the user.
1442 C080              *
1443 C080              * PRINTMSG takes the 8 bit value in the accumulator
1444 C080              *          shifts it left by 2 and uses it as an index
1445 C080              *          into a messages table of DW's defined by
1446 C080              *          MSGPOINTER.
1447 C080              *
1448 C080              * LPRINTMSG takes the 16 bit value in the accumulator
1449 C080              *          shifts it left by 2 and uses it as an index
1450 C080              *          into a messages table of DW's defined by
1451 C080              *          MSGPOINTER.
1452 C080              *
1453 C080              * Both print entry points handle data the same way.
1454 C080              *
1455 C080              * If the 1st byte of ASCII is + (Hi bit=0) then
1456 C080              *        the print routines print until an ASCII
1457 C080              *        byte with the hi bit - (Hi bit=1) is
1458 C080              *        detected.  That ASCII character is printed
1459 C080              *        as the last character in the message.
1460 C080              *
1461 C080              * If the 1st byte of ASCII is $00 then the print
1462 C080              *        routines increment to the next character
1463 C080              *        and prints until $00 is found.  This allows
1464 C080              *        strings which begin with MouseText characters
1465 C080              *        to be printed.  The $00 is NOT printed.
1466 C080              *
1467 C080              * If the 1st byte of ASCII is <$20 then the print
1468 C080              *        routines will take that number as a repeat count
1469 C080              *        and repeat the next character that many times.
1470 C080              *        It will then increment to the next character
1471 C080              *        and print until $00 is found.  This allows
1472 C080              *        strings which begin with repeated characters
1473 C080              *        to be printed.  The $00 is NOT printed.
1474 C080              *
1475 C080              * Repeat characters are handled as follows:
1476 C080              *   If LDA [PRINTTMP] = <$20 then the following is true.
1477 C080              *      The byte is the repeat indicator / number of times to repeat.
1478 C080              *      The byte after that is the repeat character.
1479 C080              *      The repeat character/number of times to repeat
1480 C080              *         indicator can appear anywhere in the string.
1481 C080              *      The maximum repeat count is $1F (31 decimal).
1482 C080              *
1483 C080              * The message length limit is 65535 characters!!!!
1484 C080              *
1485 C080              * PRINTTMP(+0 +1 +2) then locations used in
1486 C080              *       zero page are saved and restored.
1487 C080
1488 C080              PRINTMSG EQU   *
1489 C080 C2 30                 REP   #$30                     ;Off to 16 bit land
1490 C082                       LONGA ON
1491 C082 29 FF 00              AND   #$00FF                   ;High byte must be 0
1492 C085
1493 C085                       LONGA OFF
1494 C085              PRINTMSG2 EQU   *                       ;Extended print message entry point
1495 C085 A4 06                 LDY   PRINTTMP+0               ;Save zero page used on stack
1496 C087 5A                    PHY                            ;
1497 C088 A4 08                 LDY   PRINTTMP+2               ;Make room for bank num too!
1498 C08A 5A                    PHY                            ;
1499 C08B 0A                    ASL   A                        ;Shift through all 16 bits
1500 C08C A8                    TAY                            ;Transfer 16 bit 'A' to 'Y'
1501 C08D AF C0 00 E1           LDA   >MSGPOINTER              ;Set up pointer to msg tbl in zero page
1502 C091 85 06                 STA   PRINTTMP+0               ;
1503 C093 AF C1 00 E1           LDA   >MSGPOINTER+1            ;Hi byte and bank of pointer address
1504 C097 85 07                 STA   PRINTTMP+1               ;
1505 C099 B7 06                 LDA   [PRINTTMP],Y             ;Set up pointer in zero page
1506 C09B 85 06                 STA   PRINTTMP+0               ;Bank num assumed to be same as pointer's 
1507 C09D
1508 C09D E2 70                 SEP   #$70                     ;8 bits+anticipate DCI or MouseText string
1509 C09F              @2       EQU   *
1510 C09F A7 06                 LDA   [PRINTTMP]               ;First byte - then normal 
1511 C0A1 F0 18                 BEQ   @5_4                     ;=0 then printing MouseText string
1512 C0A3 C9 20                 CMP   #INVSPACE                ;<$20 then it's a repeat count
1513 C0A5 90 2A                 BCC   @11                      ;'c'=0 then it's a repeat count
1514 C0A7 B8                    CLV                            ;Clear 'v' if mixed ASCII/MouseText
1515 C0A8              @4       EQU   *
1516 C0A8 A7 06                 LDA   [PRINTTMP]               ;Get a message character
1517 C0AA F0 1A                 BEQ   @7                       ;0 is terminator
1518 C0AC C9 20                 CMP   #INVSPACE                ;<$20 then it's a repeat count
1519 C0AE 90 21                 BCC   @11                      ;'c'=0 then it's a repeat count
1520 C0B0 70 04                 BVS   @5                       ;'v'=1 then last byte is 0 (DCI/MouseText)
1521 C0B2 30 0F                 BMI   @6                       ;'v'=0 then last byte is -
1522 C0B4 09 80                 ORA   #$80                     ;Set hi bit to 1
1523 C0B6              @5       EQU   *
1524 C0B6 08                    PHP                            ;Must save 'v' 
1525 C0B7 20 D1 A9              JSR   COUTFF                   ;Print to screen
1526 C0BA 28                    PLP                            ;Must restore 'v'
1527 C0BB              @5_4     EQU   *
1528 C0BB E6 06                 INC   PRINTTMP                 ;Inc to next character
1529 C0BD D0 E9                 BNE   @4                       ;If not 0 print more
1530 C0BF E6 07                 INC   PRINTTMP+1               ;Inc hi byte if here
1531 C0C1 80 E5                 BRA   @4                       ;Always go back for more
1532 C0C3
1533 C0C3              @6       EQU   *                        ;Exit routine
1534 C0C3 20 D1 A9              JSR   COUTFF                   ;Output last character
1535 C0C6              @7       EQU   *                        ;Exit routine
1536 C0C6 C2 30                 REP   #$30                     ;16 bit land to save time
1537 C0C8 68                    PLA                            ;Restore zero page used
1538 C0C9 85 08                 STA   PRINTTMP+2               ;
1539 C0CB 68                    PLA                            ;
1540 C0CC 85 06                 STA   PRINTTMP+0               ;
1541 C0CE E2 30                 SEP   #$30                     ;8 bit land a must for monitor
1542 C0D0 60                    RTS                            ;Back to caller
1543 C0D1
1544 C0D1
1545 C0D1              * Repeat characters is handled as follows:
1546 C0D1              *   If LDA [PRINTTMP] = <$20 then the following is true.
1547 C0D1              *      The byte is the repeat indicator / number of times to repeat.
1548 C0D1              *      The byte after that is the repeat character.
1549 C0D1
1550 C0D1              @11      EQU   *
1551 C0D1 A8                    TAY                            ;Move to index as counter
1552 C0D2 E6 06                 INC   PRINTTMP                 ;Inc to next character
1553 C0D4 D0 02                 BNE   @112                     ;If not 0 then let hi byte alone
1554 C0D6 E6 07                 INC   PRINTTMP+1               ;Inc hi byte if here
1555 C0D8              @112     EQU   *
1556 C0D8 A7 06                 LDA   [PRINTTMP]               ;Get repeat character
1557 C0DA 5A                    PHY                            ;Save 'Y' around print
1558 C0DB 70 02                 BVS   @114                     ;'v'=1 then do not modify character
1559 C0DD 09 80                 ORA   #$80                     ; else set hi bit.
1560 C0DF              @114     EQU   *
1561 C0DF 08                    PHP                            ;Preserve 'v' status
1562 C0E0 20 D1 A9              JSR   COUTFF                   ;Print character
1563 C0E3 28                    PLP                            ;Restore 'v' status
1564 C0E4 7A                    PLY                            ;Recall counter
1565 C0E5 88                    DEY                            ;
1566 C0E6 D0 F0                 BNE   @112                     ;Loop til done repeating
1567 C0E8 80 D1                 BRA   @5_4                     ;Continue normal printing
1568 C0EA
1569 C0EA
1570 C0EA                                                      ; SEG $FF
1571 C0EA              NEWCMDSTBL EQU   *
1572 C0EA                                                      ; SEG $00
1573 C0EA C1                    DC B:'A'                       ;'A' location change entry
1574 C0EB D8                    DC B:'X'                       ;'X' location change entry
1575 C0EC D9                    DC B:'Y'                       ;'Y' location change entry
1576 C0ED D3                    DC B:'S'                       ;'S' location change entry
1577 C0EE C4                    DC B:'D'                       ;'D' location change entry
1578 C0EF D0                    DC B:'P'                       ;'P' location change entry
1579 C0F0 C2                    DC B:'B'                       ;'B' location change entry
1580 C0F1 CB                    DC B:'K'                       ;'K' location change entry
1581 C0F2 CD                    DC B:'M'                       ;'M' location change entry
1582 C0F3 D1                    DC B:'Q'                       ;'Q' Location change entry
1583 C0F4 CC                    DC B:'L'                       ;'L' location change entry
1584 C0F5 ED                    DC B:'m'                       ;'m' location change entry
1585 C0F6 F8                    DC B:'x'                       ;'x' location change entry
1586 C0F7 E5                    DC B:'e'                       ;'e' location change entry
1587 C0F8 E4                    DC B:'d'                       ;'d' location change entry
1588 C0F9 C6                    DC B:'F'                       ;'F' location change entry
1589 C0FA
1590 C0FA D6                    DC B:'V'                       ;'V' set video mode to resume w/
1591 C0FB D4                    DC B:'T'                       ;Display current time command
1592 C0FC 8D                    DC B:$8D                       ;Convert hex input to ASCII
1593 C0FD              NEWCMDLEN EQU   *-NEWCMDSTBL
1594 C0FD
1595 C0FD
1596 C0FD 00 00 00              DC B:3,0                       ;pad up to $C100
1597 C100
